/*
 * common.h
 *
 *  Created on: Sep 2, 2013
 *      Author: vdu1kor
 */

#ifndef COMMON_H_
#define COMMON_H_

#include "control/IAmControlReceive.h"
#include "control/IAmControlSend.h"

using namespace am;

struct rMainConnectionSet
{
   am_Handle_s handle;
   am_sourceID_t sourceID; //VVD
   am_mainConnectionID_t connectionID;

   //VVD
   //std::vector<rHandleStatus> listHandleStaus;
};
typedef enum UserRequest
{
   REQUEST_UNKNOWN = 0,
   REQUEST_SOURCE_ROUTE_ACTIVITY = 1,
   REQUEST_VOLUME = 2,
   REQUEST_MUTE_DEMUTE = 3,
   REQUEST_MSP_BASS = 4,
   REQUEST_MSP_TREBLE = 5,
   REQUEST_MSP_MIDRANGE = 6,
   REQUEST_MSP_LOUDNESS = 7,
   REQUEST_MSP_BALANCE = 8,
   REQUEST_MSP_FADER = 9,
   REQUEST_MSP_DYNA_COMPRESSION = 10,
   REQUEST_MSP_EQU_PRESET = 11,
   REQUEST_MSP_SDVC = 12,
   REQUEST_MSP_SND_OPTIMIZATION = 13,
   REQUEST_MSP_AUX = 14,
   REQUEST_MSP_BEEP_LEVEL = 15,
   REQUEST_SYP_BEEP = 16,
   REQUEST_SYP_FADER_STATUS_ACTIVE = 17,
   REQUEST_SYP_VOL_MODE = 18

}tenUserRequest;

typedef struct rSourceRouteActivity
{
   tenUserRequest enCCAResponseType;
      uint8_t Source;
      uint8_t PossibleNextSource;
      uint8_t Resource;
      uint8_t Activity;
}trSourceRouteActivity;

typedef struct rVolumeStatus
{
      uint8_t VolumeMode;
      uint8_t Resource;
      uint8_t Channel;
      uint8_t Volume;
      uint8_t Source;
}trVolumeStatus;



typedef union INC_CCA_Response
{
   //tenCCAResponse enCCAResponseType;
   trSourceRouteActivity rSrcRouteActivity;
   //trVolumeStatus rVolumeStatus;

}tuCCARepsonse;

struct rMainSinkSoundPropertySet
{
    am_sinkID_t sinkID;
    am_Handle_s handle;
    am_MainSoundProperty_s mainSoundProperty;
};

#endif /* COMMON_H_ */
